﻿var modules = {
    context: $(".v-modules"),
    datatable: null,
    SampleAssignmentMode: $("#SampleAssignmentMode").val(),
    initializeDataTable: function () {
        var a4sModuleDisplayCondition = function (data) { return data.Type == Enum.ModuleType.A4S && data.Message == null && modules.isSurveyExists(data.A4SProperties) && data.A4SProperties.SurveyStatus != 6; };

        var quickFilter = [{ "Label": resources.CATI, "AjaxParams": { "type": 1 }, "DisplayCondition": function (data) { return projectMenu.project.EnableCATI; } },
                        { "Label": resources.CAWI, "AjaxParams": { "type": 2 }, "DisplayCondition": function (data) { return projectMenu.project.EnableCAWI;} },
                        { "Label": resources.CAPI, "AjaxParams": { "type": 3 }, "DisplayCondition": function (data) { return projectMenu.project.EnableCAPI;} },
                        { "Label": resources.A4S, "AjaxParams": { "type": 4 }, "DisplayCondition": function (data) { return projectMenu.project.EnableA4S;} },
                        { "Label": resources.Pronto, "AjaxParams": { "type": 5 }, "DisplayCondition": function (data) { return projectMenu.project.EnablePronto;} },
                        { "Label": resources.Manual, "AjaxParams": { "type": 8 }, "DisplayCondition": function (data) { return projectMenu.project.EnableManual; } }];

        this.datatable = $(".h-modules-table", this.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getProjectAction("GetModules", "Modules"),
            ajaxParams: {},
            columns: [               
                { "Title": resources.Id, "Data": "Id", "Key": true, "Type": "numeric" },
                { "Data": "Message", "Tooltip": true, "AdvancedFilter": false },
                { "Title": resources.Name, "Data": "Name", "Class": "itemName", "HideInSelector": true },
                { "Title": resources.TelephonyServer, "Name": "TelephonyServer", "Data": function (row) { return row.ProntoProperties != null ? row.ProntoProperties.ProntoName : "" }, "Type": "multiple", "EnumType": "TelephonyServerOptions" },
                { "Title": resources.SampleGroup, "Name": "SampleGroup", "Data": "SampleGroup", "Visible": modules.SampleAssignmentMode == "Group", "HideInSelector": modules.SampleAssignmentMode != "Group" },
                { "Title": resources.OriginatingPhoneNumber, "Name": "OriginatingPhoneNumber", "Data": "OriginatingPhoneNumber" },
                { "Title": resources.Questionnaire, "Data": "QuestionnaireName" },
                { "Title": resources.Status, "Name": "Status", "Data": "StatusEnum", "Type": "enum", "EnumType": "SurveyStatus" },
                { "Title": resources.Type, "Name": "Type", "Data": "TypeLabel", "AdvancedFilter": false }
            ],
            stateKey: "Modules",
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.Status == 1 && voxco.security.has('DELETE'); } },
                { "Action": "activate", "Label": resources.Activate, "DisplayCondition": function (data) { return data.Status != 3 && voxco.security.has('START_STOP') && (data.Type != Enum.ModuleType.A4S || (modules.isSurveyExists([A4SProperties]) && data.A4SProperties.SurveyStatus != 6));} },
                { "Action": "pause", "Label": resources.Pause, "DisplayCondition": function (data) { return data.Status == 3 && data.Type != Enum.ModuleType.A4S && data.Type != Enum.ModuleType.CAPI && voxco.security.has('START_STOP'); } },
                { "Action": "stop", "Label": resources.Stop, "DisplayCondition": function (data) { return data.Status != 1 && voxco.security.has('START_STOP') && (data.Type != Enum.ModuleType.A4S || modules.isSurveyExists(data.A4SProperties)); } }
            ],
            contextMenuItems: [
                { "Action": "questionnaireEditor", "Label": resources.Questionnaire, "DisplayCondition": a4sModuleDisplayCondition },
                { "Action": "distribute", "Label": resources.Distribute, "DisplayCondition": a4sModuleDisplayCondition },
                { "Action": "analyze", "Label": resources.Participation, "DisplayCondition": a4sModuleDisplayCondition },
                { "Divider": true, "DisplayCondition": function (data) { return data.Type == Enum.ModuleType.A4S && data.Message == null && modules.isSurveyExists(data.A4SProperties); } },

                { "Action": "synchronize", "Label": resources.SynchronizeQuestionnaire, "DisplayCondition": a4sModuleDisplayCondition },
                { "Action": "viewLastSyncReport", "Label": resources.ViewLastSynchronizationReport, "DisplayCondition": function (data) { return data.Type == Enum.ModuleType.A4S && modules.isSurveyExists(data.A4SProperties); } },
                { "Action": "viewSynchronizationHistory", "Label": resources.ViewSynchronizationHistory, "DisplayCondition": function (data) { return data.Type == Enum.ModuleType.A4S && modules.isSurveyExists(data.A4SProperties); } },
                { "Action": "viewIntegrationTasks", "Label": resources.ViewIntegrationTasks, "DisplayCondition": function (data) { return data.Type == Enum.ModuleType.A4S && modules.isSurveyExists(data.A4SProperties); } },
                { "Divider": true, "DisplayCondition": function (data) { return data.Type == Enum.ModuleType.A4S && modules.isSurveyExists(data.A4SProperties); } },

                { "Action": "appearance", "Label": resources.Appearance, "DisplayCondition": function (data) { return voxco.security.has('CAN_USE_APPEARANCE') && (data.Type == Enum.ModuleType.CATI || data.Type == Enum.ModuleType.CAWI || data.Type == Enum.ModuleType.CAPI); } },
                { "Action": "interviewers", "Label": resources.Advanced, "DisplayCondition": function (data) { return _.contains([1, 2, 3, 14, 15], data.ProntoModuleType); } },
                { "Action": "advancedProperties", "Label": resources.Advanced, "DisplayCondition": function (data) { return voxco.security.has('START_STOP') && (data.Type == Enum.ModuleType.CATI); } },
                { "Divider": true },

                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.Status == 1 && voxco.security.has('DELETE'); } },
                { "Action": "deletesurvey", "Label": resources.DeleteModuleAndSurvey, "DisplayCondition": function (data) { return data.Status == 1 && data.Message == null && voxco.security.has('DELETE') && data.Type == Enum.ModuleType.A4S && data.A4SProperties.SurveyStatus != 6; } },
                { "Action": "properties", "Label": resources.Properties, "DisplayCondition": function (data) { return data.Type != Enum.ModuleType.A4S || modules.isSurveyExists(data.A4SProperties); } },
                { "Action": "users", "Label": resources.Users, "DisplayCondition": function (data) { return voxco.security.has('ADD_USERS_TO_PROJECT') && data.ProntoModuleType != 6 && data.Type != Enum.ModuleType.CAWI && data.Type != Enum.ModuleType.A4S; }},
                { "Action": "agents", "Label": resources.Agents, "DisplayCondition": function (data) { return _.contains([1, 2, 3, 11, 14, 15], data.ProntoModuleType); } },
                { "Divider": true, "DisplayCondition": function (data) { return voxco.security.has('START_STOP'); } },

                { "Action": "activate", "Label": resources.Activate, "DisplayCondition": function (data) { return data.Status != 3 && voxco.security.has('START_STOP') && (data.Type != Enum.ModuleType.A4S || (modules.isSurveyExists(data.A4SProperties) && data.A4SProperties.SurveyStatus != 6)); } },
                { "Action": "pause", "Label": resources.Pause, "DisplayCondition": function (data) { return data.Status == 3 && data.Type != Enum.ModuleType.A4S && data.Type != Enum.ModuleType.CAPI && voxco.security.has('START_STOP'); } },
                { "Action": "stop", "Label": resources.Stop, "DisplayCondition": function (data) { return data.Status != 1 && voxco.security.has('START_STOP') && (data.Type != Enum.ModuleType.A4S || modules.isSurveyExists(data.A4SProperties)); } },
                { "Action": "activateSurvey", "Label": resources.ActivateSurvey, "DisplayCondition": function (data) { return voxco.security.has('START_STOP') && data.Type == Enum.ModuleType.A4S && modules.isSurveyExists(data.A4SProperties) && modules.surveyStatusIsNotOnline(data.A4SProperties) && data.A4SProperties.SurveyStatus != 6; } },
                { "Action": "updateServeyLiveVersion", "Label": resources.UpdateLiveVersion, "DisplayCondition": function (data) { return data.Type == Enum.ModuleType.A4S && data.Message == null && modules.isSurveyExists(data.A4SProperties) && modules.showSurveyUpdateLiveVersionOption(data.A4SProperties) && data.Status != 4 && voxco.security.has('START_STOP') && data.A4SProperties.SurveyStatus != 6; } },
                { "Divider": true },

                { "Action": "test", "Label": resources.TestQuestionnaire, "DisplayCondition": function (data) { return data.HasTestSurveyURL && data.Status == 3; } },
                { "Action": "execute", "Label": resources.ExecuteSampleMode, "DisplayCondition": function (data) { return data.HasSurveyURL && data.Status == 3; } },
                { "Divider": true, "DisplayCondition": function (data) { return data.Type == Enum.ModuleType.A4S; } },

                { "Action": "previewA4S", "Label": resources.PreviewQuestionnaire, "DisplayCondition": function (data) { return data.Status == 3 && data.Type == Enum.ModuleType.A4S && data.Message == null && modules.isSurveyExists(data.A4SProperties) && data.A4SProperties.SurveyStatus != 6; } },
                { "Action": "testA4S", "Label": resources.TestQuestionnaire, "DisplayCondition": function (data) { return data.Status == 3 && data.Type == Enum.ModuleType.A4S && data.Message == null && modules.isSurveyExists(data.A4SProperties) && data.A4SProperties.SurveyStatus != 6; } },
                { "Action": "executeA4S", "Label": resources.ExecuteSampleMode, "DisplayCondition": function (data) { return data.Status == 3 && data.Type == Enum.ModuleType.A4S && data.Message == null && modules.isSurveyExists(data.A4SProperties) && data.A4SProperties.SurveyStatus != 6; } }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "appearance":
                        modules.editAppearance(row.Id);
                        break;
                    case "test":
                        window.open(row.TestSurveyURL, "_newtab");
                        break;
                    case "execute":
                        window.open(row.SurveyURL, "_newtab");
                        break;
                    case "activate":
                        modules.startModules([row.Id], row.Name);
                        break;
                    case "pause":
                        modules.pauseModules([row.Id], row.Name);
                        break;
                    case "stop":
                        modules.stopModules([row.Id], row.Name, [row.Type]);
                        break;
                    case "delete":
                        modules.deleteModules([row.Id]);
                        break;
                    case "deletesurvey":
                        modules.deleteModules([row.Id], true);
                        break;
                    case "properties":
                        modules.editModules(row.Id, row.Type, row.ProntoModuleType, "properties");
                        break;
                    case "users":
                        modules.editModules(row.Id, row.Type, row.ProntoModuleType, "users");
                        break;
                    case "agents":
                        modules.editModules(row.Id, row.Type, row.ProntoModuleType, "Advanced");
                        break;
                    case "interviewers":
                        modules.editInterviewers(row.Id, row.ProntoModuleType);
                        break;
                    case "advancedProperties":
                        modules.editAdvancedProperties(row.Id, row.ProntoModuleType);
                        break;
                    case "previewA4S":
                        modules.openSurveyEngine(row, 0);
                        break;
                    case "testA4S":
                        modules.openSurveyEngine(row, 1);
                        break;
                    case "executeA4S":
                        modules.openSurveyEngine(row);
                        break;
                    case "questionnaireEditor":
                        modules.openQuestionnaireEditor(row);
                        break;
                    case "distribute":
                        modules.openDistribute(row);
                        break;
                    case "analyze":
                        modules.openAnalyze(row);
                        break;
                    case "synchronize":
                        modules.startSync(row);
                        break;
                    case "activateSurvey":
                        modules.activate(row);
                        break;
                    case "updateServeyLiveVersion":
                        modules.updateServeyLiveVersion(row);
                        break;
                    case "viewLastSyncReport":
                        modules.viewLastSyncReport(row);
                        break;
                    case "viewSynchronizationHistory":
                        modules.viewSynchronizationHistory(row.Id);
                        break;
                    case "viewIntegrationTasks":
                        modules.viewIntegrationTasks(row.Id);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");
                var name = ids.length == 1 ? rows[0].Name : "";

                switch (action) {
                    case "delete":
                        modules.deleteModules(ids);
                        break;
                    case "activate":
                        modules.startModules(ids, name);
                        break;
                    case "pause":
                        modules.pauseModules(ids, name);
                        break;
                    case "stop":
                        var types = _.pluck(rows, "Type");
                        modules.stopModules(ids, name, types);
                        break;
                }
            },
            quickFilter: {
                "DisplayMode": "buttons",
                "Items": quickFilter
            },
            localizableTexts: { "All": resources.AllModules, "Search": resources.SearchModules }
        });
    },
    bindEvents: function () {
        var options = { afterClose: projectMenu.refresh };

        $(".h-newModuleMenu").on("click", "li.h-newCAWI", function () {
            modalDialog.showWindow(a4.getProjectAction("EditCawi", "Modules"), 650, 850, options);
        });

        $(".h-newModuleMenu").on("click", "li.h-newCAPI", function () {
            modalDialog.showWindow(a4.getProjectAction("EditCapi", "Modules"), 600, 850, options);
        });

        $(".h-newModuleMenu").on("click", "li.h-newCATI", function () {
            modalDialog.showWindow(a4.getProjectAction("EditCati", "Modules"), 675, 960, options);
        });

        $(".h-newModuleMenu").on("click", "li.h-newA4S", function () {
            modalDialog.showWindow(a4.getProjectAction("EditA4S", "Modules"), 500, 700, options);
        });

        $(".h-newModuleMenu").on("click", "li.h-newPronto", function () {
            var type = $(this).attr("prontoType");
            var pronto = $(this).attr("pronto");
            var moduleType = $(this).attr("moduleType");
            modalDialog.showWindow(a4.getProjectAction("EditPronto", "Modules", { prontoType: type, pronto: pronto, moduleType: moduleType }), 650, 850, options);
        });

        $(".h-newModuleMenu").on("click", "li.h-newManual", function () {
            var type = $(this).attr("prontoType");
            modalDialog.showWindow(a4.getProjectAction("EditManual", "Modules", { prontoType: type }), 650, 850, options);
        });

        projectMenu.onAfterRefresh = modules.refreshContent; //Call refreshContent after menu refresh
    },
    deleteModules: function (moduleIds, deleteSurvey) {
        modalDialog.showConfirmDelete(confirmDeleteModulesResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteModules", "Modules"), { moduleIds: moduleIds, deleteSurvey: deleteSurvey },
                function (result) {
                    projectMenu.refresh();
                });
        }, moduleIds.length);
    },
    editModules: function (moduleId, type, prontoModuleType, activeTab) {
        var options = { afterClose: modules.refreshContent };

        switch (type) {
            case 1:
                modalDialog.showWindow(a4.getProjectAction("EditCati", "Modules", { moduleId: moduleId, activeTab: activeTab }), 700, 1000, options);
                break;
            case 2:
                modalDialog.showWindow(a4.getProjectAction("EditCawi", "Modules", { moduleId: moduleId, activeTab: activeTab }), 650, 850, options);
                break;
            case 3:
                modalDialog.showWindow(a4.getProjectAction("EditCapi", "Modules", { moduleId: moduleId, activeTab: activeTab }), 600, 850, options);
                break;
            case 4:
                modalDialog.showWindow(a4.getProjectAction("EditA4S", "Modules", { moduleId: moduleId, activeTab: activeTab }), 500, 700, options);
                break;
            case 5: case 6: case 7: case 8:
                modalDialog.showWindow(a4.getProjectAction("EditPronto", "Modules", { moduleId: moduleId, prontoType: prontoModuleType, moduleType: type, activeTab: activeTab }), 650, 850, options);
                break;
        }
    },
    editAppearance: function (moduleId) {
        modalDialog.showWindow(a4.getProjectAction("Appearance", "Modules", { moduleId: moduleId }), 1000, 1400, { afterClose: modules.refreshContent });
    },
    editAdvanced: function (moduleId, prontoModuleType) {
        modalDialog.showWindow(a4.getProjectAction("EditAdvanced", "Modules", { moduleType: prontoModuleType, moduleId: moduleId }), 650, 700, { afterClose: modules.refreshContent });
    },
    editInterviewers: function (moduleId, prontoModuleType) {
        modalDialog.showWindow(a4.getProjectAction("EditInterviewers", "Modules", { moduleType: prontoModuleType, moduleId: moduleId }), 650, 700, { afterClose: modules.refreshContent });
    },
    editAdvancedProperties: function (moduleId) {
        modalDialog.showWindow(a4.getProjectAction("EditAdvancedProperties", "Modules", { moduleId: moduleId }), 400, 800, { afterClose: modules.refreshContent });
    },
    refreshContent: function () {
        modules.datatable.a4datatable("refresh");

        var project = projectMenu.project;

        if (!project.EnableCATI && !project.EnableCAWI && !project.EnableCAPI && !project.EnableA4S && !project.EnablePronto && !project.EnableManual)
            window.location = a4.getProjectAction("Index", "Home", {});

        $(".h-newModuleMenu li.h-newCATI", modules.context).toggle(project.EnableCATI);
        $(".h-newModuleMenu li.h-newCAWI", modules.context).toggle(project.EnableCAWI);
        $(".h-newModuleMenu li.h-newCAPI", modules.context).toggle(project.CanCreateCAPIModule);
        $(".h-newModuleMenu li.h-newA4S", modules.context).toggle(project.CanCreateA4SModule);
        $(".h-newModuleMenu li.h-newPronto-main", modules.context).toggle(project.CanCreateProntoModule);
        $(".h-newModuleMenu li.h-newManual-main", modules.context).toggle(project.CanCreateManualModule);

        var showNewButton = voxco.security.has('MODIFY') && project.CanCreateModule && (project.EnableCATI || project.EnableCAWI || project.CanCreateCAPIModule || project.CanCreateA4SModule || project.CanCreateProntoModule || project.CanCreateManualModule);

        $(".h-newModuleMenu").toggle(showNewButton);
    },
    startModules: function (moduleIds, name) {
        modalDialog.showConfirmDialog((moduleIds.length > 1) ? confirmStartModulesResources : confirmStartModuleResources, function () {
            a4.callServerMethod(a4.getProjectAction("StartModule", "Modules"), { moduleIds: moduleIds }, function (result) {
                projectMenu.refresh();
            });
        }, null, null, false, { "modulename": name, "count": moduleIds.length });
    },
    pauseModules: function (moduleIds, name) {
        modalDialog.showConfirmDialog((moduleIds.length > 1) ? confirmPauseModulesResources : confirmPauseModuleResources, function () {
            a4.callServerMethod(a4.getProjectAction("PauseModule", "Modules"), { moduleIds: moduleIds }, function (result) {
                projectMenu.refresh();
            });
        }, null, null, false, { "modulename": name, "count": moduleIds.length });
    },
    stopModules: function (moduleIds, name, moduleTypes) {
        var dialogResources = (moduleIds.length > 1) ? confirmStopModulesResources : confirmStopModuleResources;

        if (_.contains(moduleTypes, parseInt(Enum.ModuleType.CATI, 10)) || _.contains(moduleTypes, parseInt(Enum.ModuleType.CAWI, 10)))
            dialogResources = (moduleIds.length > 1) ? confirmStopModulesWithWarningResources : confirmStopModuleWithWarningResources;

        modalDialog.showConfirmDialog(dialogResources, function () {
            a4.callServerMethod(a4.getProjectAction("StopModule", "Modules"), { moduleIds: moduleIds }, function (result) {
                projectMenu.refresh();
            });
        }, 250, 500, false, { "modulename": name, "count": moduleIds.length });
    },
    showBusyBox: function () {
        a4.showBusyBox();
    },
    hideBusyBox: function () {
        a4.hideBusyBox();
    },
    getSurveyId: function (row) {
        return row.A4SProperties.SurveyId;
    },
    openSurveyEngine: function (row, mode) {
        window.open(a4.getProjectAction("RedirectToSurveyURL", "Modules", { surveyId: modules.getSurveyId(row), mode: mode }), "_newtab");
    },
    openQuestionnaireEditor: function (row) {
        window.location = a4.getSurveyAction("Edit", "Questionnaire", { surveyId: modules.getSurveyId(row) });
    },
    openDistribute: function (row) {
        window.location = a4.getSurveyAction("Index", "Distribute", { surveyId: modules.getSurveyId(row) });
    },
    openAnalyze: function (row) {
        window.location = a4.getSurveyAction("Participation", "Analyze", { surveyId: modules.getSurveyId(row) });
    },
    isSynchronized: function (a4sProperties) {
        return a4sProperties != null && a4sProperties.LastSynchronization != null && a4sProperties.LastSynchronization.length > 0;
    },
    startSync: function (row) {
        if (modules.isSynchronized(row.A4SProperties)) {
            modalDialog.showWindow(a4.getProjectAction("SynchronizeQuestionnaireAdvanced", "Modules", { moduleId: row.Id }), 300, 600, { afterClose: function (doNotShowTasks) { if (!doNotShowTasks) modules.viewIntegrationTasks(row.Id); } });
        }
        else
            a4.callServerMethod(a4.getProjectAction("SynchronizeQuestionnaire", "Modules"), { moduleId: row.Id }, function (result) {
                modules.datatable.a4datatable("refresh");
                modules.viewIntegrationTasks(row.Id);
            });
    },
    activate: function (row) {
        a4.callServerMethod(a4.getProjectAction("ActivateSurvey", "Modules"), { moduleId: row.Id, surveyId: modules.getSurveyId(row) }, function (result) {
            modules.datatable.a4datatable("refresh");
        });
    },
    updateServeyLiveVersion: function (row) {
        a4.callServerMethod(a4.getProjectAction("UpdateSurveyLiveVersion", "Modules"), { surveyId: modules.getSurveyId(row) }, function (result) {
            modules.datatable.a4datatable("refresh");
        });
    },
    viewLastSyncReport: function (row) {
        modalDialog.showWindow(a4.getProjectAction("ViewSynchronizationReport", "Modules", { moduleId: row.Id }), 300, 600);
    },
    viewSynchronizationHistory: function (moduleId) {
        modalDialog.showWindow(a4.getProjectAction("ViewSynchronizationHistory", "Modules", { moduleId: moduleId }), 500, 1000);
    },
    viewIntegrationTasks: function (moduleId) {
        modalDialog.showWindow(a4.getProjectAction("ViewIntegrationTasks", "Modules", { moduleId: moduleId }), 500, 1000);
    },
    isSurveyExists: function (a4sProperties) {
        return typeof a4sProperties != "undefined" && a4sProperties != null && a4sProperties.SurveyId != null && a4sProperties.SurveyId != "0";
    },
    showSurveyUpdateLiveVersionOption: function (a4sProperties) {
        return typeof a4sProperties != "undefined" && a4sProperties != null && a4sProperties.PendingChanges;
    },
    surveyStatusIsNotOnline: function (a4sProperties) {
        return a4sProperties.SurveyStatus == 4;
    },
}

$(document).ready(function () {
    if (modules.context.length > 0) {
        modules.initializeDataTable();
        modules.bindEvents();
    }
});